# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable-next=consider-using-from-import
import CliGlobal
import ConfigMount
import ExternalServicesConstants
from CliPlugin.ExternalHttpServices import ExternalHttpServicesConfigMode
from CliPlugin.ExternalHttpServices import ExternalHttpServicesVrfConfigMode
from CliDynamicSymbol import CliDynamicPlugin

HttpServiceHandler = CliDynamicPlugin( "HttpServiceHandler" )

# -----------------------------------------------------------------------------------
# Mount path holders ( Define all mount path holders here )
# -----------------------------------------------------------------------------------
gv = CliGlobal.CliGlobal(
   dict(
      capiConfig=None,
   )
)

# -------------------------------------------------------------------------------
# Command Helper Function
# -------------------------------------------------------------------------------
def shutdownExternalServices( mode ):
   gv.capiConfig.service[ ExternalServicesConstants.SERVICE_NAME ].enabled = False

def removeExternalServiceVrfs( mode, args ):
   HttpServiceHandler.removeVrfFromService( gv.capiConfig,
                                     ExternalServicesConstants.SERVICE_NAME,
                                     args.get( 'VRF' ) )

# -------------------------------------------------------------------------------
# BasicCli Command Handler Function
# -------------------------------------------------------------------------------
def enterExternalHttpServicesModeHandler( mode, args ):
   childMode = mode.childMode( ExternalHttpServicesConfigMode )
   mode.session_.gotoChildMode( childMode )

def enterEHSModeNoOrDefaultHandler( mode, args ):
   shutdownExternalServices( mode )
   removeExternalServiceVrfs( mode, {} )

# -------------------------------------------------------------------------------
# ExternalHttpServicesConfigMode Command Handler Function
# -------------------------------------------------------------------------------
def shutdownExternalHttpServicesHandler( mode, args ):
   shutdownExternalServices( mode )

def shutdownExternalHttpServicesNoHandler( mode, args ):
   if ( not gv.capiConfig.httpsConfig.enabled and
        not gv.capiConfig.httpConfig.enabled and
        not gv.capiConfig.localHttpConfig.enabled and
        not gv.capiConfig.unixConfig.enabled ):
         # No protocol is enabled
      mode.addWarning( "No protocols are enabled" )
   gv.capiConfig.service[ ExternalServicesConstants.SERVICE_NAME ].enabled = True

def enterExternalHttpServicesVrfConfigMode( mode, args ):
   vrfName = args[ 'VRF' ]
   if not gv.capiConfig.service[ ExternalServicesConstants.SERVICE_NAME ].enabled:
      # pylint: disable-next=consider-using-f-string
      mode.addWarning( "Cannot configure external-services in VRF %s because "
                       "the service is globally disabled. Please enable service in "
                       "'management api external-services' mode first" % vrfName )
   childMode = mode.childMode( ExternalHttpServicesVrfConfigMode, vrfName=vrfName )
   mode.session_.gotoChildMode( childMode )

# -------------------------------------------------------------------------------
# ExternalHttpServicesVrfConfigMode Command Handler Function
# -------------------------------------------------------------------------------
def vrfModeShutdownHandler( mode, args ):
   mode.shutdown()

def vrfModeShutdownNoHandler( mode, args ):
   mode.noShutdown()

def Plugin( entityManager ):
   gv.capiConfig = ConfigMount.mount( entityManager,
                                      "mgmt/capi/config",
                                      "HttpService::Config",
                                      "w" )
