#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import LazyMount

routingHwStatusCommon = None
routingHwStatus = None
routing6HwStatus = None

def handlerSetMaxEcmpCmd( mode, args ):
   maxEcmp = args.get( "MAX", 16 )
   routingHwStatus.maxLogicalProtocolEcmp = maxEcmp
   routing6HwStatus.maxLogicalProtocolEcmp = maxEcmp
   routingHwStatus.maxUcmp = maxEcmp
   routing6HwStatus.maxUcmp = maxEcmp

def handlerShowMaxEcmpCmd( mode, args ):
   print( f"maximum-paths: {routingHwStatus.maxLogicalProtocolEcmp}," +
          f" ipv6: {routing6HwStatus.maxLogicalProtocolEcmp } " )

def Plugin( entityManager ):
   global routingHwStatusCommon
   global routingHwStatus
   global routing6HwStatus

   # These are not Cli Config roots --- so we don't use ConfigMount, even
   # though they are being mounted "w".  Normally setting maxEcmp is a property
   # of the system, and not typically set by the Cli.  However, for etba
   # duts, for testing purposes, this is a cli configurable property.
   routingHwStatusCommon = LazyMount.mount( entityManager,
                                            "routing/hardware/statuscommon",
                                            "Routing::Hardware::StatusCommon", "w" )
   routingHwStatus = LazyMount.mount( entityManager, "routing/hardware/status",
                                      "Routing::Hardware::Status", "w" )
   routing6HwStatus = LazyMount.mount( entityManager, "routing6/hardware/status",
                                       "Routing6::Hardware::Status", "w" )
