#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import IraRouteCommon
from IpLibConsts import DEFAULT_VRF
import Tac

ipRedirect = IraRouteCommon.Ip4()
routing = IraRouteCommon.routing( ipRedirect )

def enableSoftwareIpOptionsDrop( mode, args ):
   routingConfig = routing.config( DEFAULT_VRF )
   routingConfig.ipOptionsSoftwareDropEnabled = True

def disableSoftwareIpOptionsDrop( mode, args ):
   routingConfig = routing.config( DEFAULT_VRF )
   routingConfig.ipOptionsSoftwareDropEnabled = False

def Plugin( entityManager ):
   routing.plugin( entityManager )
