#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import ConfigMount
import Tracing
from IpLibConsts import DEFAULT_VRF
from CliPlugin.IraRouterKernel import (
   RouterKernelConfigMode,
   routerKernelVrfHook
)

# To be able to mount hwEpoch/status when loading plugin:
# pkgdeps: rpmwith %{_libdir}/preinit/HwEpoch
traceHandle = Tracing.Handle( 'IraRouterKernel' )
t5 = traceHandle.trace5 # Info
allVrfConfig = None

def handlerRouterKernelConfigModeCmd( mode, args ):
   vrfName = args.get( "VRF", DEFAULT_VRF )
   t5( "Switcing to router kernel mode, vrf", vrfName )
   childMode =\
       mode.childMode( RouterKernelConfigMode, vrfName=vrfName )
   mode.session_.gotoChildMode( childMode )
   allVrfConfig.kernelNetConfig.newMember( vrfName )
   # Create the vrf config if it does not exist
   routerKernelVrfHook.notifyExtensions( vrfName, True )

def noOrDefaultHandlerRouterKernelConfigModeCmd( mode, args ):
   vrfName = args.get( "VRF", DEFAULT_VRF )
   if not vrfName:
      vrfName = DEFAULT_VRF
   t5( "Switcing to router kernel mode, vrf", vrfName )
   del allVrfConfig.kernelNetConfig[ vrfName ]
   # Delete the vrf config if we are deleting the mode
   routerKernelVrfHook.notifyExtensions( vrfName, False )

def Plugin( entityManager ):
   global allVrfConfig

   allVrfConfig = ConfigMount.mount( entityManager, "ip/vrf/config",
                                     "Ip::AllVrfConfig", "w" )
