# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
from CliModel import Model, Dict, Int, List
from IntfModels import Interface

#--------------------------------------------------------------------------------
# show kernel software forwarding hardware offload summary vrf [ VRF ]
#--------------------------------------------------------------------------------
class Fwd0EthTypeEntry( Model ):
   vlanId = Int( help="Forwarding VLAN ID" )
   protocols = List( valueType=str,
                     help="The protocols that are enabled on this forwarding "
                          "device" )

class Fwd0EthTypeEntries( Model ):
   forwardDevices = Dict( valueType=Fwd0EthTypeEntry,
                          help="A mapping of forward device to its attributes" )

class Fwd0EthTypeEntriesVrfs( Model ):
   vrfs = Dict( valueType=Fwd0EthTypeEntries,
                help="A mapping of VRF to its forward devices" )

#--------------------------------------------------------------------------------
# show kernel software forwarding hardware offload config-sanity vrf [ VRF ]
#--------------------------------------------------------------------------------
class Fwd0EthTypeConfigSanityEntry ( Fwd0EthTypeEntry ):
   urpfEnabledIntf = Interface( help="uRPF enabled routed interface", optional=True )
   aclEnabledIntf = Interface( help="ACL enabled routed interface", optional=True )

class Fwd0EthTypeConfigSanityEntries( Model ):
   forwardDevices = Dict( valueType=Fwd0EthTypeConfigSanityEntry,
                          help="A mapping of forward device to its attributes" )

class Fwd0EthTypeConfigSanityEntriesVrfs( Model ):
   vrfs = Dict( valueType=Fwd0EthTypeConfigSanityEntries,
                help="A mapping of VRF to its forward devices" )
