# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliGlobal import CliGlobal
import ConfigMount
from TypeFuture import TacLazyType

CardProfileDescriptor = TacLazyType( 'L1Profile::CardProfileDescriptor' )
CardProfileSource = TacLazyType( 'L1Profile::CardProfileSource::CardProfileSource' )
CliConfig = TacLazyType( 'L1Profile::CliConfig' )
MountConstants = TacLazyType( 'L1Profile::MountConstants' )

gv = CliGlobal( cliConfig=None )

def handler( mode, args ):
   # Config agent ingests the startup config before any of the builtin profiles
   # have had a chance to load. As such, disambiguating between the source of the
   # profile referenced by the CLI command is pointless. We always configure the
   # source as "unknown" and rely on the processing stages to resolve the unknown
   # source.
   desc = CardProfileDescriptor( CardProfileSource.unknown, args[ 'PROFILE' ] )

   if 'MOD' in args:
      modules = args[ 'MOD' ]
      for moduleId in modules.values():
         module = f'{modules.type.tagLong}{moduleId}'
         gv.cliConfig.cardProfile[ module ] = desc
   else:
      gv.cliConfig.cardProfile[ 'FixedSystem' ] = desc

def noOrDefaultHandler( mode, args ):
   if 'MOD' in args:
      modules = args[ 'MOD' ]
      for moduleId in modules.values():
         module = f'{modules.type.tagLong}{moduleId}'
         del gv.cliConfig.cardProfile[ module ]
   else:
      del gv.cliConfig.cardProfile[ 'FixedSystem' ]

def cardProfileMapCleanup():
   gv.cliConfig.cardProfile.clear()

def Plugin( entityManager ):
   gv.cliConfig = ConfigMount.mount(
      entityManager,
      MountConstants.cliConfigPath(),
      CliConfig.tacType.fullTypeName,
      'w' )
