#!/usr/bin/env python3
# Copyright (c) 2020, 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
from CliPlugin.IraIpModel import VrfLdpIpRoutes
from CliPlugin.IraIpRouteCliLib import ip
from CliPlugin import IraRouteCommon
from CliPlugin.VrfCli import DEFAULT_VRF
from CliPrint import CliPrint
import sys
import TacSigint

printer = CliPrint().lib

ldpRibRouting = IraRouteCommon.LdpRibRouting( ip )

def handlerLdpRibShortcutCmd( mode, args ):
   prefix = args.pop( 'PREFIX', None )
   vrfName = DEFAULT_VRF
   outputFormat = printer.stringToOutputFormat( mode.session_.outputFormat_ )
   fd = sys.stdout.fileno()

   p = printer.initPrinter( fd, outputFormat, True )
   printer.startRender( p )
   printer.startDict( p, "vrfs" )

   # See comment in IraIpCli.showRoute for why its needed to check for SIGINT here
   TacSigint.check()

   printer.startDict( p, vrfName )

   fmt = mode.session_.outputFormat()
   requestedRevision = mode.session_.requestedModelRevision()

   # revision 2 makes srTePolicy in cbfVias to be optional when RSVP CBF is use
   rsvpCbfViaRevision = 2

   json = not mode.session_.shouldPrint()
   degradeCbfViasModel = json and requestedRevision < rsvpCbfViaRevision

   ldpRibRouting.showRoute( prefix, None, None, False, vrfName, fmt=fmt,
      degradeCbfViasModel=degradeCbfViasModel )

   printer.endDict( p, vrfName )
   printer.endDict( p, "vrfs" )
   printer.endRender( p )
   printer.deinitPrinter( p )
   return VrfLdpIpRoutes
