# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliDynamicSymbol import CliDynamicPlugin

LSCL = CliDynamicPlugin( 'LineSystemCliLib' )
LSIM = CliDynamicPlugin( 'LineSystemShowIdpromModel' )
XSIH = CliDynamicPlugin( 'XcvrShowIdpromHandler' )

# -------------------------------------------------------------------------------
# Handlers for "show line system [PORT X] idprom"
# -------------------------------------------------------------------------------

def lineSystemDoIdpromDump( mode, xcvrStatus, xcvrDir, intfs, model ) -> None:
   """
   Wrapper for Xcvr extended idprom dump function
   """
   XSIH.doExtendedIdpromDump( mode, xcvrStatus, xcvrDir, intfs, model )

def showLineSystemIdpromHandler( mode, args ) -> object:
   model = LSIM.LineSystemIdpromBase()
   portRange = args.get( 'PORTRANGE' )
   intfRangeLineSys = LSCL.lineSystemIntfsInPortRange( mode, portRange )
   if not intfRangeLineSys:
      return model

   XSIH.createIdpromDumpRequest( mode, intfRangeLineSys, includeAuxiliary=True )
   XSIH.xcvrIdpromDumpFunc( mode, lineSystemDoIdpromDump,
                            model, intfRangeLineSys, includeAuxiliary=True )

   # Change "Ethernet" strings to "Port" after command completion. We want our
   # CLI to use the word "Port" for LineSystem-based CLI, as linesystems do not have
   # ethernet capability.
   for intf in sorted( model.interfaces.keys(), key=LSCL.subPrefixToPort ):
      portName = LSCL.subPrefixToPort( intf )
      model.interfaces[ portName ] = model.interfaces[ intf ]
      del model.interfaces[ intf ]
   return model
