# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliDynamicSymbol import CliDynamicPlugin
from CliModel import Dict, Model

XSIM = CliDynamicPlugin( 'XcvrShowIdpromModel' )

# --------------------------------------------------------------------------------
# Models for "show line system [<ports>] idprom"
# --------------------------------------------------------------------------------

class LineSystemIdpromBase( Model ):
   interfaces = Dict( keyType=str,
                      valueType=XSIM.InterfacesTransceiverIdpromPages,
                      help='Mapping between port name and the eeprom' )

   def render( self ) -> None:
      if not self.interfaces:
         return
      for intf in self.interfaces:
         self.interfaces[ intf ].renderModel( intf )
         print()
