#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import ConfigMount
from CliDynamicSymbol import CliDynamicPlugin

LoopProtectCli = CliDynamicPlugin( "LoopProtectCli" )
config = None

def gotoMonitorLoopProtectMode( mode, args ):
   childMode = mode.childMode( LoopProtectCli.MonitorLoopProtectConfigMode )
   mode.session_.gotoChildMode( childMode )

def noMonitorLoopProtect( mode, args ):
   config.globalEnabled = False
   if config.transmitConfig:
      config.transmitConfig.rateLimit = LoopProtectCli.RATE_LIMIT_DEFAULT
   if config.globalIntfConfig:
      config.globalIntfConfig.disabledTime = LoopProtectCli.DISABLED_TIME_DEFAULT
      config.globalIntfConfig.transmitInterval = \
         LoopProtectCli.TRANSMIT_INTERVAL_DEFAULT
   config.vlanEnabled.clear()

def Plugin( entityManager ):
   global config
   config = ConfigMount.mount( entityManager, 'loopprotect/config',
                               'LoopProtect::Config::Config', 'w' )