#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import ConfigMount

config = None 

def intfLoopProtect( mode, args ):
   intf = str( mode.intf )
   del config.intfExclude[ intf ]

def noIntfLoopProtect( mode, args ):
   intf = str( mode.intf )
   config.intfExclude[ intf ] = True

def Plugin( entityManager ):
   global config
   config = ConfigMount.mount( entityManager, 'loopprotect/config',
                               'LoopProtect::Config::Config', 'w' )