#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Arnet
from ArnetModel import IpGenericPrefix
from CliModel import Dict
from CliModel import List
from CliModel import Model
from TableOutput import createTable
from TableOutput import Format

class MatchListInfo( Model ):

   class MatchList( Model ):
      prefixes = List( valueType=IpGenericPrefix,
            help='List of configured segment prefixes' )
   matchLists = Dict( keyType=str, valueType=MatchList,
         help='A mapping of match list name to prefixes' )

   def render( self ):
      headings = ( 'Name', 'Prefix' )
      table = createTable( headings )
      f1 = Format( justify='left' )
      f1.noPadLeftIs( True )
      f1.padLimitIs( True )
      table.formatColumns( f1, f1 )

      for matchListName in sorted( self.matchLists ):
         firstRow = True
         prefixes = self.matchLists[ matchListName ].prefixes
         for prefix in sorted( prefixes,
               key=lambda prefix: Arnet.IpGenPrefix( prefix ).sortKey ):
            if firstRow:
               table.newRow( matchListName, prefix )
               firstRow = False
            else:
               table.newRow( '', prefix )
      print( table.output() + "\n" )
