# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import CliGlobal
import ConfigMount
from CliPlugin import RouterMulticastCliLib

gv = CliGlobal.CliGlobal( dict( config=None ) )

class UnresolvedPktFloodCleanup( RouterMulticastCliLib.RouterModeCallbackBase ):
   def modeDeleted(self, **kwargs):
      gv.config.pktFlooded = False

def floodPkt( mode, args ):
   gv.config.pktFlooded = True

def noFloodPkt( mode, args ):
   gv.config.pktFlooded = False

def Plugin( em ):
   gv.config = ConfigMount.mount( em, 'routing/multicast/hardwareConfig',
   'MrouteLib::MulticastHardwareConfig', 'w')
   RouterMulticastCliLib.RouterMulticastMode.registerCallback(
                                                      UnresolvedPktFloodCleanup() )