# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliModel

class HardwareFabricEjectorHandleModel( CliModel.Model ):
   ejectorHandleOpenAction = CliModel.Enum( values=( 'power-off', 'log' ),
         help='Action performed when ejector handle is opened',
         optional=True )

   def render( self ):
      print( f'Ejector handle open action is {self.ejectorHandleOpenAction}\n' )
