#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import OcspProfile
from CliPlugin.Security import registerSecurityCleanupCallback
import ConfigMount
import Tac

SslConstants = Tac.Type( "Mgmt::Security::Ssl::Constants" )

config = None

def GotoOcspProfileModeCmd_handler( mode, args ):
   """Handler for 'ocsp profile OCSP_PROFILE'"""
   ocspProfileName = args[ "OCSP_PROFILE" ]
   ocspProfileConfig = config.newOcspProfileConfig( ocspProfileName )

   childMode = mode.childMode( OcspProfile.OcspProfileConfigMode,
                               ocspProfileConfig=ocspProfileConfig )
   mode.session_.gotoChildMode( childMode )

def GotoOcspProfileModeCmd_noOrDefaultHandler( mode, args ):
   """Handler for '( no | default ) ocsp profile OCSP_PROFILE'"""
   ocspProfileName = args[ "OCSP_PROFILE" ]
   del config.ocspProfileConfig[ ocspProfileName ]

def OcspCertRequirementCmd_handler( mode, args ):
   """
   Handler for '[ no | default ] chain certificate requirement responder
      [ all | leaf | none ]'
   """
   certRequirement = args.get( "SETTING", "all" )
   mode.config().certRequirement = Tac.enumValue(
      "Mgmt::Security::Ssl::OcspCertRequirement", certRequirement )

def OcspNonceCmd_handler( mode, args ):
   """
   Handler for '[ no | default ] extension nonce request [ disabled | response ]'
   """
   nonceArg = args.get( "SETTING", "request" )
   mode.config().nonce = Tac.enumValue( "Mgmt::Security::Ssl::OcspNonceSetting",
                                        nonceArg )

def OcspTimeoutCmd_handler( mode, args ):
   """Handler for '[ no | default ] timeout <SECONDS>'"""
   mode.config().timeout = args.get( "SECONDS", SslConstants.defaultOcspTimeout )

def OcspUrlCmd_handler( mode, args ):
   """Handler for '[ no | default ] url <URL>'"""
   mode.config().url = args.get( "URL", "" )

def OcspVrfCmd_handler( mode, args ):
   """Handler for '[ no | default ] vrf <VRF>'"""
   mode.config().vrfName = args.get( "VRF", "default" )

def Plugin( entityManager ):
   global config
   config = ConfigMount.mount( entityManager, "mgmt/security/ssl/config",
                               "Mgmt::Security::Ssl::Config", "w" )
   # pylint: disable-next=unnecessary-lambda
   registerSecurityCleanupCallback( lambda: config.ocspProfileConfig.clear() )
