# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import PhyCli
from TypeFuture import TacLazyType

# Helper function to return an enum value based on CLI input
def cdrModeStrToEnum( cdrModeStr ):
   cdrModeEnum = TacLazyType( "Hardware::Phy::CdrMode" )
   return { 'auto' : cdrModeEnum.autoCdr,
            'baud-rate' : cdrModeEnum.baudRateCdr,
            'oversampling' : cdrModeEnum.oversamplingCdr }[ cdrModeStr ]

def handler( mode, args ):
   cfg = PhyCli.getPhyCliFeatureConfig( mode.intf )
   cfg.cdrMode = cdrModeStrToEnum( args[ 'CDRMODE' ] )

def noOrDefaultHandler( mode, args ):
   cfg = PhyCli.getPhyCliFeatureConfig( mode.intf )
   cfg.cdrMode = TacLazyType( "Hardware::Phy::CdrMode" ).defaultCdr
