#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliExtensions
import ConfigMount
import Plugins

# --------------------------------------------------------------------------------
# Variables for Qos Policy associated mount paths from Sysdb
# --------------------------------------------------------------------------------
cliQosAclConfig = None

# --------------------------------------------------------------------------------
# Handler of HwAccessListQosResourceSharingVlanInCmd
# --------------------------------------------------------------------------------
def enableQosAclSharing( mode, args ):
   cliQosAclConfig.sviPolicyQosSharing = True

# --------------------------------------------------------------------------------
# No or default handler of HwAccessListQosResourceSharingVlanInCmd
# --------------------------------------------------------------------------------
def disableQosAclSharing( mode, args ):
   cliQosAclConfig.sviPolicyQosSharing = False


routedPortSubIntfQosAclSharingCanPromptForAbortHook = CliExtensions.CliHook()

# --------------------------------------------------------------------------------
# Handler of RoutedPortSubintfCmd
# --------------------------------------------------------------------------------
def gotoRoutedPortSubIntfAclSharing( mode, args ):
   cliQosAclConfig.usingQosRoutedPortSubIntfAclSharingCli = 'qos' in args
   shareWithSubIntf = not CliCommand.isNoOrDefaultCmd( args )
   aclType = 'qos'

   if aclType == 'qos':
      if cliQosAclConfig.routedPortSubIntfQosAclSharing == shareWithSubIntf:
         return
      if mode.session.commandConfirmation():
         for hook in \
             routedPortSubIntfQosAclSharingCanPromptForAbortHook.extensions():
            if hook( mode ):
               return

      cliQosAclConfig.routedPortSubIntfQosAclSharing = shareWithSubIntf

def matchMacAccessGroupAccessCmdHandler( mode, args ):
   noOrDefault = CliCommand.isNoOrDefaultCmd( args )
   mode.setMatchValue( noOrDefault, 'mac', args[ 'GROUP' ] )

def matchIpAccessGroupCmdHandler( mode, args ):
   noOrDefault = CliCommand.isNoOrDefaultCmd( args )
   mode.setMatchValue( noOrDefault, 'ip', args[ 'GROUP' ] )

def matchIpv6AccessGroupCmdHandler( mode, args ):
   noOrDefault = CliCommand.isNoOrDefaultCmd( args )
   mode.setMatchValue( noOrDefault, 'ipv6', args[ 'GROUP' ] )

@Plugins.plugin( provides=( "QosCliPolicy", ) )
def Plugin( entityManager ):
   global cliQosAclConfig
   cliQosAclConfig = ConfigMount.mount( entityManager, "qos/acl/input/cli",
                                        "Qos::Input::AclConfig", "w" )
