# Copyright (c) 2018, 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#------------------------------------------------------------------------------------
# This module provides "show rib next-hop resolution route [ipv4|ipv6] (vrf <name>)"
# functions
#------------------------------------------------------------------------------------

from __future__ import absolute_import, division, print_function
from CliPlugin.IraCommonCli import ribRouteModel
from IpLibConsts import DEFAULT_VRF
from RibCapiLib import (
   showRibCapiCommand,
   EmptyResponseException,
)
import json
from socket import (
   AF_INET,
   AF_INET6,
)
import sys

def showResolutionRibdRoute( af, mode, vrfName ):
   assert 'IpRib' in ribRouteModel

   args = {}
   args[ 'af' ] = AF_INET if af == 'ipv4' else AF_INET6

   if vrfName != DEFAULT_VRF:
      args[ 'vrfName' ] = vrfName

   cmd = "MIO_DGET_RIB_RESOLUTION_ROUTE"

   try:
      model = showRibCapiCommand( mode,
                                  ribRouteModel[ 'IpRib' ].ResolutionRoutes,
                                  cmd, args=args )
   except EmptyResponseException:
      model = ribRouteModel[ 'IpRib' ].ResolutionRoutes()

   if mode.session_.shouldPrint():
      model.renderResolutionRoutes( af, vrfName=vrfName )
   else:
      encoder = json.JSONEncoder( indent=4, sort_keys=False )
      for chunk in encoder.iterencode( model.toDict( streaming=True ) ):
         sys.stdout.write( chunk )
      # Output is always newline terminated
      sys.stdout.write( '\n' )
