#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import (
   DeferredModel,
   Int,
   List,
   Str,
)

class RouteTrackLogEvent( DeferredModel ):
   __public__ = False
   nsSinceBoot = Int( help='Elapsed nanoseconds since switch boot' )
   timestamp = Str( help='Trace entry timestamp' )
   description = Str( help='Event description' )
   agent = Str( help='Name of agent that produced the event' )
   epoch = Int( help='Route track configuration epoch', optional=True )
   eventId = Int( help='Event ID assigned by the producing agent',
                  optional=True )
   context = Str( help='Reference to code that produced the event',
                  optional=True )

class RouteTrackLog( DeferredModel ):
   '''Model for show route track'''
   __public__ = False
   events = List( valueType=RouteTrackLogEvent, help='Tracked route events' )
   wrappedLogs = List( valueType=str,
                       help='Agent logs that wrapped resulting in lost events',
                       optional=True )
   matchedEpoch = Int(
      help='Route track configuration epoch used to match entries in agent logs',
      optional=True )
