# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliDynamicSymbol import CliDynamicPlugin
import CliPlugin.RoutingBgpShowCli

RoutingBgpShowCliHandler = CliDynamicPlugin( "RoutingBgpShowCliHandler" )

def handlerShowBgpAccessList( mode, args ):
   return CliPlugin.RoutingBgpShowCli.showBgpAcl( mode,
      addressFamily=args.get( "addrFamily" ),
      name=args.get( "<aclNameExpr>" ) )

def handlerShowBgpInstanceInternal( mode, args ):
   return RoutingBgpShowCliHandler.doShowBgpInstance(
      mode,
      internal=args[ "internal" ],
      vrfName=args.get( "VRF" ) )

def handlerShowBgpInstance( mode, args ):
   return RoutingBgpShowCliHandler.doShowBgpInstance(
      mode,
      vrfName=args.get( "VRF" ) )

def handlerShowBgpPeerGroup( mode, args ):
   pgName = args.get( "PG_NAME" )
   vrfName = args.get( "VRF" )
   return CliPlugin.RoutingBgpShowCli.doShowIpBgpPeerGroup(
      mode,
      pgAndVrfName=( pgName, vrfName ) )

def handlerShowBgpUpdateGroup( mode, args ):
   opt = args.get( "INDEX" ) or args.get( "PEER" )
   return RoutingBgpShowCliHandler.doShowBgpUpdateGroup(
      mode,
      opt=opt,
      vrfName=args.get( "VRF" ) )

def handlerShowBgpTrafficPolicyFieldSetMappings( mode, args ):
   return CliPlugin.RoutingBgpShowCli.doShowBgpTrafficPolicyFieldSetMappings(
      mode,
      vrfName=args.get( "VRF" ) )

def handlerShowBgpVrfSelectionPolicyFieldSetMappings( mode, args ):
   return CliPlugin.RoutingBgpShowCli.doShowBgpVrfSelectionPolicyFieldSetMappings(
      mode, vrfName=None )

def handlerShowBgpConvergence( mode, args ):
   return CliPlugin.RoutingBgpShowCli.doShowBgpConvergence(
         mode, vrfName=args.get( "VRF" ) )

def handlerShowBgpStatistics( mode, args ):
   return CliPlugin.RoutingBgpShowCli.doShowBgpStatistics(
         mode, vrfName=args.get( "VRF" ) )
