#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import CliDynamicSymbol

RoutingBgpShowCli = CliDynamicSymbol.loadDynamicPlugin(
   "RoutingBgpShowCli" )

def ShowBgpLuTunnel_handler( mode, args ):
   return RoutingBgpShowCli.showBgpLuTunnelTable(
      mode, tunnelIndex=args.get( "TUNNELIDX_VAL" ) )

def ShowBgpLuTunnelRaw_handler( mode, args ):
   return RoutingBgpShowCli.showBgpLuTunnelTableNoFlattening(
      mode, tunnelIndex=args.get( "TUNNELIDX_VAL" ) )

def ShowBgpLuForwarding_handler( mode, args ):
   return RoutingBgpShowCli.showBgpLuForwardingTunnelTable(
      mode, tunnelIndex=args.get( "TUNNELIDX_VAL" ) )

def ShowBgpLuForwardingRaw_handler( mode, args ):
   return RoutingBgpShowCli.showBgpLuForwardingTunnelTableNoFlattening(
      mode, tunnelIndex=args.get( "TUNNELIDX_VAL" ) )

def ShowBgpUdpTunnel_handler( mode, args ):
   return RoutingBgpShowCli.showBgpUdpTunnelTable()
