#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliPlugin.RoutingBgpShowCli
from CliPlugin.RoutingBgpCli import (
      PeerConfigKey
)

def ShowBgpMultiSafi_handler( mode, args ):
   return CliPlugin.RoutingBgpShowCli.doShowBgpNlriAf(
      mode,
      addressFamilyAndType=args.get( "addressFamilyAndType" ),
      communityValuesAndExact=args.get( "communityValuesAndExact" ),
      aspListName=args.get( "AS_PATH_LIST_NAME" ),
      detail=args.get( "detail" ),
      vrfName=args.get( "VRF" ),
      internal=args.get( "internal" ) )

def ShowBgpMultiSafiSummary_handler( mode, args ):
   return CliPlugin.RoutingBgpShowCli.doShowBgpNlriAfSummary(
      mode,
      addressFamilyAndType=args.get( "addressFamilyAndType" ),
      vrfName=args.get( "VRF" ) )

def ShowIpBgpLargeCommunityListLegacySyntax_handler( mode, args ):
   extraArgs = {
         "detail": args[ "detail" ],
         "vrfName": args.get( "VRF" ),
      }
   return CliPlugin.RoutingBgpShowCli.doShowIpBgpLargeCommunity(
         mode,
         values=set( args[ "LARGE_COMM_VALUE" ] ),
         exact=args.get( "exact" ),
         **extraArgs )

def ShowIpBgpCommunityRegexp_handler( mode, args ):
   return CliPlugin.RoutingBgpShowCli.doShowIpBgpRoutesCommunitiesRegexp(
      mode, regex=args[ "REGEX" ], vrfName=args.get( "VRF" ) )

def ShowIpBgpAddrOrPrefix_handler( mode, args ):
   if args.get( "IP" ):
      addr = args.get( "IP" )
   else:
      addr = args.get( "PREFIX" )
   return CliPlugin.RoutingBgpShowCli.doShowIpBgp(
      mode,
      addr=addr,
      longerPrefixes=args.get( "longer-prefixes" ),
      detail=args.get( "detail" ),
      internal=args.get( "internal" ),
      vrfName=args.get( "VRF" ),
      labUni=args.get( "labeled-unicast" ) )

def ShowIpv6BgpLargeCommunityListLegacySyntax_handler( mode, args ):
   extraArgs = {
      "detail": args.get( "detail" ),
      "vrfName": args.get( "VRF" ),
   }
   return CliPlugin.RoutingBgpShowCli.doShowIpv6BgpLargeCommunity(
      mode,
      values=set( args[ "LARGE_COMM_VALUE" ] ),
      exact=args.get( "exact" ),
      **extraArgs )

def ShowBgpNeighborsPeerRouteType_handler( mode, args ):
   return CliPlugin.RoutingBgpShowCli.doShowBgpNeighborsNlriAfRoutes(
      mode,
      peerAddr=args[ "PEER" ],
      routeFamilyAndType=args.get( "addressFamilyAndType" ),
      aspListName=args.get( "AS_PATH_LIST_NAME" ),
      routeType=args[ "route-type" ],
      filtered=args.get( "filtered" ),
      communityValuesAndExact=args.get( "communityValuesAndExact" ),
      detail=args.get( "detail" ),
      vrfName=args.get( "VRF" )
   )

def ShowBgpNeighborsPeerIp_handler( mode, args ):
   return CliPlugin.RoutingBgpShowCli.doShowBgpNeighborsNlriAfPrefixAddr(
      mode,
      peerAddr=args[ "PEER" ],
      routeType=args[ "route-type" ],
      filtered=args.get( "filtered" ),
      pfxAddr=args[ "ADDR" ],
      longerPrefixes=args.get( "longer-prefixes" ),
      communityValuesAndExact=args.get( "communityValuesAndExact" ),
      detail=args.get( "detail" ),
      vrfName=args.get( "VRF" )
   )

def ShowBgpNeighbors_handler( mode, args ):
   return CliPlugin.RoutingBgpShowCli.doShowBgpNeighbors(
      mode,
      addr=args.get( "PEER" ),
      internal=args.get( "INTERNAL" ),
      taskStats=args.get( "TASK_STATS" ),
      vrfName=args.get( "VRF" )
   )

def ShowIpBgpRegexp_handler( mode, args ):
   return CliPlugin.RoutingBgpShowCli.doShowIpBgpRegexp(
      mode, regex=args[ "REGEX" ], vrfName=args.get( "VRF" ) )

def ShowIpBgpRoutesAsPath_handler( mode, args ):
   return CliPlugin.RoutingBgpShowCli.doShowIpBgpRoutesAsPath(
      mode, aspListName=args.get( "AS_PATH_LIST_NAME" ),
      detail=args.get( "detail" ),
      vrfName=args.get( "VRF" ) )

def ShowIpv6BgpRoutesAsPath_handler( mode, args ):
   return CliPlugin.RoutingBgpShowCli.doShowIpv6BgpRoutesAsPath(
      mode, aspListName=args.get( "AS_PATH_LIST_NAME" ),
      detail=args.get( "detail" ),
      vrfName=args.get( "VRF" ) )

def ShowIpv6BgpRegexp_handler( mode, args ):
   return CliPlugin.RoutingBgpShowCli.doShowIpv6BgpRegexp(
      mode,
      regex=args[ "REGEX" ],
      vrfName=args.get( "VRF" ) )

def ShowBgpNlriAf_handler( mode, args ):
   return CliPlugin.RoutingBgpShowCli.doShowBgpNlriAf(
      mode,
      addressFamilyAndType=args.get( "addressFamilyAndType" ),
      pfxAddr=args[ "ADDR" ],
      longerPrefixes=args.get( "longer-prefixes" ),
      communityValuesAndExact=args.get( "communityValuesAndExact" ),
      detail=args.get( "detail" ),
      vrfName=args.get( "VRF" ),
      internal=args.get( "internal" ) )

def ShowIpAnyBgpNeighborsAddrRouteType_handler( mode, args ):
   """
   Note: This handler also handles the syntax defined in
   ShowIpAnyBgpNeighborsReceivedRoutes
   """
   peerAddr = args.get( "PEER" )
   peerRouterId = args.get( "ROUTER_ID" )
   ipv6 = args.get( "peers" ) # peers keyword => ipv6
   afiSafi = args.get( "addressFamilyAndType" )

   routeOrAdvRoute = args.get( "routes" ) or args.get( "advertised-routes" )
   filteredArg = args.get( "filtered" )

   detailArg = args.get( "detail" )
   vrfName = args.get( "VRF" )

   regex = args.get( "regex" )
   commsAndExact = args.get( "communityValuesAndExact" )
   aspListName = args.get( "AS_PATH_LIST_NAME" )
   ipv4OrIpv6Addr = args.get( "IPV4_OR_IPV6_ADDR" )
   ipv4OrIpv6AddrMask = args.get( "IPV4_OR_IPV6_ADDR_MASK" )

   if ( ipv4OrIpv6Addr or ipv4OrIpv6AddrMask ) and routeOrAdvRoute:
      # (routes|advertised-routes) (ipv4Addr|ipv6Addr)
      # (routes|advertised-routes) (ipv4AddrMask|ipv6AddrMask) [longer-prefixes]
      otherArgs = {}
      if ipv4OrIpv6AddrMask:
         otherArgs[ "longerPrefixes" ] = args.get( "longer-prefixes" )

      if ipv6:
         return CliPlugin.RoutingBgpShowCli.doShowIpv6BgpNeighborsPrefixAddr(
               mode,
               peerAddr=peerAddr,
               routeType=routeOrAdvRoute,
               pfxAddr=ipv4OrIpv6Addr or ipv4OrIpv6AddrMask,
               routerId=peerRouterId,
               vrfName=vrfName,
               **otherArgs )
      else:
         return CliPlugin.RoutingBgpShowCli.doShowIpBgpNeighborsPrefixAddr(
               mode,
               peerAddr=peerAddr,
               routeType=routeOrAdvRoute,
               pfxAddr=ipv4OrIpv6Addr or ipv4OrIpv6AddrMask,
               routerId=peerRouterId,
               vrfName=vrfName,
               **otherArgs )

   elif ( ipv4OrIpv6Addr or ipv4OrIpv6AddrMask ) and not routeOrAdvRoute:
      # received-routes [filtered] (ipv4Addr|ipv6Addr)
      # received-routes [filtered] (ipv4AddrMask|ipv6AddrMask) [longer-prefixes]
      otherArgs = {}
      if ipv4OrIpv6AddrMask:
         otherArgs[ "longerPrefixes" ] = args.get( "longer-prefixes" )

      if ipv6:
         return CliPlugin.RoutingBgpShowCli.\
               doShowIpv6BgpNeighborsPrefixAddrRecvdRts(
               mode,
               pfxAddr=ipv4OrIpv6Addr or ipv4OrIpv6AddrMask,
               peerAddr=peerAddr,
               filtered=filteredArg,
               routerId=peerRouterId,
               vrfName=vrfName,
               **otherArgs )
      else:
         return CliPlugin.RoutingBgpShowCli.\
               doShowIpBgpNeighborsPrefixAddrRecvdRts(
               mode,
               pfxAddr=ipv4OrIpv6Addr or ipv4OrIpv6AddrMask,
               peerAddr=peerAddr,
               filtered=filteredArg,
               routerId=peerRouterId,
               vrfName=vrfName,
               **otherArgs )

   elif commsAndExact and routeOrAdvRoute:
      # (routes|advertised-routes) community {VALS} [exact] [detail]
      if ipv6:
         return CliPlugin.RoutingBgpShowCli.doShowIpv6BgpNeighborsCommunityRoutes(
               mode,
               addr=peerAddr,
               routeType=routeOrAdvRoute,
               values=commsAndExact[ "communityValues" ],
               exact=commsAndExact.get( "exact" ),
               detail=detailArg,
               routerId=peerRouterId,
               vrfName=vrfName )
      else:
         return CliPlugin.RoutingBgpShowCli.doShowIpBgpNeighborsCommunityRoutes(
               mode,
               addr=peerAddr,
               routeType=routeOrAdvRoute,
               values=commsAndExact[ "communityValues" ],
               exact=commsAndExact.get( "exact" ),
               detail=detailArg,
               routerId=peerRouterId,
               vrfName=vrfName )

   elif commsAndExact and not routeOrAdvRoute:
      # received-routes [filtered] community {VALS} [exact] [detail]
      if ipv6:
         return CliPlugin.RoutingBgpShowCli.\
               doShowIpv6BgpNeighborsCommunityRecvdRoutes(
                     mode,
                     values=commsAndExact[ "communityValues" ],
                     addr=peerAddr,
                     filtered=filteredArg,
                     exact=commsAndExact.get( "exact" ),
                     detail=detailArg,
                     routerId=peerRouterId,
                     vrfName=vrfName )
      else:
         return CliPlugin.RoutingBgpShowCli.\
               doShowIpBgpNeighborsCommunityRecvdRoutes(
                  mode,
                  values=commsAndExact[ "communityValues" ],
                  addr=peerAddr,
                  filtered=filteredArg,
                  exact=commsAndExact.get( "exact" ),
                  detail=detailArg,
                  routerId=peerRouterId,
                  vrfName=vrfName )

   elif aspListName and routeOrAdvRoute:
      # (routes|advertised-routes) as-path access-list {AS_PATH_LIST_NAME}
      if ipv6:
         return CliPlugin.RoutingBgpShowCli \
                         .doShowIpv6BgpNeighborsAsPathListRoutes(
               mode,
               addr=peerAddr,
               routeType=routeOrAdvRoute,
               aspListName=aspListName,
               detail=detailArg,
               vrfName=vrfName )
      else:
         return CliPlugin.RoutingBgpShowCli.doShowIpBgpNeighborsAsPathListRoutes(
               mode,
               addr=peerAddr,
               routeType=routeOrAdvRoute,
               aspListName=aspListName,
               detail=detailArg,
               vrfName=vrfName )

   elif aspListName and not routeOrAdvRoute:
      # received-routes [filtered] as-path access-list {AS_PATH_LIST_NAME}
      if ipv6:
         return CliPlugin.RoutingBgpShowCli.\
            doShowIpv6BgpNeighborsAsPathListRecvdRoutes(
                     mode,
                     aspListName=aspListName,
                     addr=peerAddr,
                     filtered=filteredArg,
                     detail=detailArg,
                     vrfName=vrfName )
      else:
         return CliPlugin.RoutingBgpShowCli.\
            doShowIpBgpNeighborsAsPathListRecvdRoutes(
                  mode,
                  aspListName=aspListName,
                  addr=peerAddr,
                  filtered=filteredArg,
                  detail=detailArg,
                  vrfName=vrfName )

   elif regex and routeOrAdvRoute:
      # (routes|advertised-routes) regex REGEX
      if ipv6:
         return CliPlugin.RoutingBgpShowCli.doShowIpv6BgpNbrRtsRegex(
               mode,
               nbrAddr=peerAddr,
               routeType=routeOrAdvRoute,
               regex=args[ "REGEX" ],
               routerId=peerRouterId,
               vrfName=vrfName )
      else:
         return CliPlugin.RoutingBgpShowCli.doShowIpBgpNbrRtsRegex(
               mode,
               nbrAddr=peerAddr,
               routeType=routeOrAdvRoute,
               regex=args[ "REGEX" ],
               routerId=peerRouterId,
               vrfName=vrfName )

   elif regex and not routeOrAdvRoute:
      # received-routes [filtered] regex REGEX
      if ipv6:
         return CliPlugin.RoutingBgpShowCli.doShowIpv6BgpNbrRecvdRtsRegex(
               mode,
               regex=args[ "REGEX" ],
               nbrAddr=peerAddr,
               filtered=filteredArg,
               routerId=peerRouterId,
               vrfName=vrfName )
      else:
         return CliPlugin.RoutingBgpShowCli.doShowIpBgpNbrRecvdRtsRegex(
               mode,
               regex=args[ "REGEX" ],
               nbrAddr=peerAddr,
               filtered=filteredArg,
               routerId=peerRouterId,
               vrfName=vrfName )

   elif routeOrAdvRoute:
      # [UNICAST_AFI_SAFI] (routes|advertised-routes) [detail]
      if ipv6:
         return CliPlugin.RoutingBgpShowCli.doShowIpv6BgpNeighborsRoutes(
               mode,
               peerAddr=peerAddr,
               routeType=routeOrAdvRoute,
               routeFamilyAndType=afiSafi,
               detail=detailArg,
               routerId=peerRouterId,
               vrfName=vrfName )
      else:
         return CliPlugin.RoutingBgpShowCli.doShowIpBgpNeighborsRoutes(
               mode,
               peerAddr=peerAddr,
               routeType=routeOrAdvRoute,
               routeFamilyAndType=afiSafi,
               detail=detailArg,
               routerId=peerRouterId,
               vrfName=vrfName )

   elif not routeOrAdvRoute:
      # [UNICAST_AFI_SAFI] received-routes [filtered] [detail]
      if ipv6:
         return CliPlugin.RoutingBgpShowCli.doShowIpv6BgpNeighborsReceivedRoutes(
               mode,
               peerAddr=peerAddr,
               filtered=filteredArg,
               routeFamilyAndType=afiSafi,
               detail=detailArg,
               routerId=peerRouterId,
               vrfName=vrfName )
      else:
         return CliPlugin.RoutingBgpShowCli.doShowIpBgpNeighborsReceivedRoutes(
               mode,
               peerAddr=peerAddr,
               filtered=filteredArg,
               routeFamilyAndType=afiSafi,
               detail=detailArg,
               routerId=peerRouterId,
               vrfName=vrfName )

   mode.addErrors( "show command not implemented" )
   return None

def ShowIpAnyBgpNeighborsAdvRoutesQueued_handler( mode, args ):
   peerAddr = ( args.get( "IP_PEER" ) or args.get( "IP6_PEER" ) or
                args.get( "IP6_LL_PEER" ) )
   assert peerAddr
   peerAddr = PeerConfigKey( peerAddr )

   ipv6 = args.get( "peers" ) # peers keyword => ipv6
   afiSafi = args.get( "addressFamilyAndType" )
   vrfName = args.get( "VRF" )

   if not ipv6:
      # "show ip" (not "show ipv6")
      return CliPlugin.RoutingBgpShowCli.doShowIpBgpNeighborsQueuedWithdrawals(
         mode,
         peerAddr=peerAddr,
         queuedWithdrawals=args[ 'queued-withdrawals' ],
         routeFamilyAndType=afiSafi,
         vrfName=vrfName )
   else:
      # "show ipv6" (not "show ip")
      return CliPlugin.RoutingBgpShowCli.doShowIpv6BgpNeighborsQueuedWithdrawals(
         mode,
         peerAddr=peerAddr,
         queuedWithdrawals=args[ 'queued-withdrawals' ],
         routeFamilyAndType=afiSafi,
         vrfName=vrfName )

def ShowIpv6BgpAddrOrPrefix_handler( mode, args ):
   if args.get( "IP" ):
      addr = args.get( "IP" )
   else:
      addr = args.get( "PREFIX" )
   return CliPlugin.RoutingBgpShowCli.doShowIpv6Bgp(
      mode,
      addr=addr,
      longerPrefixes=args.get( "longer-prefixes" ),
      detail=args.get( "detail" ),
      internal=args.get( "internal" ),
      vrfName=args.get( "VRF" ),
      labUni=args.get( "labeled-unicast" ) )
