#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliPlugin.RoutingBgpShowCli

def showBgpSrTeSummaryHandler( mode, args ):
   return CliPlugin.RoutingBgpShowCli.doShowBgpSrTeSummary(
            mode,
            addressFamily=args.get( "addrFamily" ),
            vrfName=args.get( "VRF" ) )

def showBgpSrTeHandler( mode, args ):
   return CliPlugin.RoutingBgpShowCli.doShowBgpSrTeRoutes(
            mode,
            addressFamily=args.get( "addrFamily" ),
            detail=args.get( "detail" ),
            vrfName=args.get( "VRF" ) )

def showBgpSrTeEndpointColorDistinguisherHandler( mode, args ):
   return CliPlugin.RoutingBgpShowCli.doShowBgpSrTeRoutes(
            mode,
            endpoint=args[ "ENDPOINT_VALUE" ],
            color=args[ "COLOR_VALUE" ],
            distinguisher=args[ "DISTINGUISHER_VALUE" ],
            detail=args.get( "detail" ),
            vrfName=args.get( "VRF" ) )

def showBgpSrTeCommunityHandler( mode, args ):
   return CliPlugin.RoutingBgpShowCli.doShowBgpSrTeRoutesCommunities(
            mode,
            addressFamily=args.get( "addrFamily" ),
            values=args[ "communityValue" ],
            exact=args.get( "exact" ),
            detail=args.get( "detail" ),
            vrfName=args.get( "VRF" ) )

def showBgpSrTeCommunityListHandler( mode, args ):
   return CliPlugin.RoutingBgpShowCli.doShowBgpSrTeRoutesCommunityList(
            mode,
            addressFamily=args.get( "addrFamily" ),
            commListName=args[ "COMM_LIST_NAME" ],
            exact=args.get( "exact" ),
            detail=args.get( "detail" ),
            vrfName=args.get( "VRF" ) )

def showBgpNeighborsSrTePoliciesHandler( mode, args ):
   return CliPlugin.RoutingBgpShowCli.doShowBgpSrTeNeighborRoutes(
            mode,
            peerAddr=args[ "PEER" ],
            addressFamily=args.get( "addrFamily" ),
            policyFilter=args[ "POLICY_FILTER" ],
            detail=args.get( "detail" ),
            vrfName=args.get( "VRF" ) )
