# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from AgentCommandRequest import runCliPrintSocketCommand
from CliPlugin.SfeAvtShowFlowCli import gv
from CliPlugin.WanTEShowCli import getVniAvtId
from CliDynamicSymbol import CliDynamicPlugin
from CliModel import cliPrinted
import Tac

SfeAvtShowFlowModel = CliDynamicPlugin( "SfeAvtShowFlowModel" )

def doShowAvtFlowsAgentCommand( mode, params ):
   model = runCliPrintSocketCommand( mode.entityManager,
                                     'Sfe',
                                     'sfe-adaptive-virtual-topology',
                                     params,
                                     mode,
                                     keepalive=True,
                                     connErrMsg='Sfe agent is inactive',
                                     model=SfeAvtShowFlowModel.AvtFlowsModel )
   return cliPrinted( model ) if model else None

def ShowAvtFlowsHandler( mode, args ):
   if not gv.avtCliConfig.avtConfigured:
      mode.addError( "Adaptive virtual topology is not configured" )
      return None

   params = 'flow'
   vrfName = args.get( 'VRF' )
   if vrfName:
      params += f' vrfName={vrfName}'

   avtName = args.get( 'AVT' )
   # default VRF may not have an VNI
   _, avtId = getVniAvtId( mode, vrfName, avtName, verifyVni=False )
   if avtName and not avtId:
      return None
   if avtId:
      params += f' avtId={avtId}'

   srcIpAddr = args.get( 'SRC_IP' )
   if srcIpAddr:
      params += f' srcIp={srcIpAddr}'
   dstIpAddr = args.get( 'DST_IP' )
   if dstIpAddr:
      params += f' dstIp={dstIpAddr}'
   srcPort = args.get( 'SRC_PORT' )
   if srcPort:
      params += f' srcPort={srcPort}'
   dstPort = args.get( 'DST_PORT' )
   if dstPort:
      params += f' dstPort={dstPort}'
   protocol = args.get( 'PROTOCOL' )
   if protocol:
      if protocol.isdigit():
         protoNumber = int( protocol )
      else:
         protoStr = 'ipProto' + protocol.capitalize()
         try:
            protoNumber = Tac.enumValue( "Arnet::IpProtocolNumber", protoStr )
         except AttributeError:
            mode.addError( f'Unknown protocol {protocol}' )
            return None
      params += f' protocol={protoNumber}'

   return doShowAvtFlowsAgentCommand( mode, params )
