#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliDynamicSymbol import CliDynamicPlugin
from CliPlugin.ArBgpCli import ArBgpAsyncCliCommand
from CliPlugin.RoutingBgpShowCli import ArBgpShowOutput

ArBgpCliHandler = CliDynamicPlugin( "ArBgpCliHandler" )
BgpVpnCliHandler = CliDynamicPlugin( "BgpVpnCliHandler" )
VpnCliHelperCommand = BgpVpnCliHandler.VpnCliHelperCommand
ShowBgpVplsModels = CliDynamicPlugin( "ShowBgpVplsModels" )

@ArBgpShowOutput( "doShowBgpVpls", arBgpModeOnly=True )
def doShowBgpVpls( mode, args ):
   VpnCliHelperCommand( mode, "show bgp vpls", "l2vpnVpls", **args ).run()
   return ShowBgpVplsModels.BgpVplsRoutes

# class BgpVplsSummaryCommand( ShowCommand.ShowCliCommandClass ):
@ArBgpShowOutput( "BgpVplsSummaryCommand", arBgpModeOnly=True )
def BgpVplsSummaryCommand_handler( mode, args ):
   nlriType = args.pop( 'nlriType', None )
   if nlriType:
      return ArBgpCliHandler.doShowIpBgpSummaryAcrImpl( mode, nlriType=nlriType )
   else:
      return ArBgpCliHandler.doShowIpBgpSummaryAcrImpl(
         mode, nlriAfiSafi="l2vpnVpls" )

# class BgpVplsAdCommand( ShowCommand.ShowCliCommandClass ):
@ArBgpShowOutput( "doShowBgpVplsAutoDiscovery", arBgpModeOnly=True )
def BgpVplsAdCommand_handler( mode, args ):
   cmd = ArBgpAsyncCliCommand( mode, "show bgp vpls auto-discovery" )
   cmd.addParam( "instance", args.get( "INSTANCE", "" ) )
   cmd.addParam( "group", args.get( "GROUP", "" ) )
   cmd.run()
   return ShowBgpVplsModels.BgpVplsAdInstances

# class BgpVplVeCommand( ShowCommand.ShowCliCommandClass ):
@ArBgpShowOutput( "doShowBgpVplsSignaling", arBgpModeOnly=True )
def BgpVplsVeCommand_handler( mode, args ):
   cmd = ArBgpAsyncCliCommand( mode, "show bgp vpls signaling" )
   cmd.addParam( "instance", args.get( "INSTANCE", "" ) )
   cmd.addParam( "group", args.get( "GROUP", "" ) )
   cmd.run()
   return ShowBgpVplsModels.BgpVplsVeInstances

# class BgpVplsCommand( ShowCommand.ShowCliCommandClass ):
def BgpVplsCommand_handler( mode, args ):
   return doShowBgpVpls( mode, args )

# class BgpVplsNeighborsCmd( ShowCommand.ShowCliCommandClass ):
def BgpVplsNeighborsCmd_handler( mode, args ):
   return doShowBgpVpls( mode, args )
