# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPrint import JSON
import SmashUtils
import Tac
from CliDynamicSymbol import CliDynamicPlugin
import json as JsonUtils

SmashModel = CliDynamicPlugin( "SmashModel" )

def showSmashClientsAll( mode, args, json ):
   cmd = SmashUtils.smashWhoAll()
   if json:
      cmd = SmashUtils.smashWhoAllJson()
   try:
      # run smash scanner to print all the clients. Note that we need to run this
      # command as root for meaningful information to be displayed.
      output = Tac.run( cmd, stdout=Tac.CAPTURE,
                        stderr=Tac.DISCARD,
                        asRoot=True )
      return output
   except Tac.SystemCommandError:
      mode.addError( 'Error printing smash clients' )
      return None

def _getCapacityModel( capacityJson ):
   capacityModel = SmashModel.CapacityInfo( slots=None, buckets=None,
                                             primaryNotifications=None,
                                             secondaryNotifications=None )
   capacityModel.setAttrsFromDict( capacityJson )
   return capacityModel

def _getHeaderInfoModel( headerJson ):
   headerInfoModel = SmashModel.HeaderInfo()
   headerInfoModel.capacity = \
      _getCapacityModel( headerJson[ 'capacity' ] )
   headerInfoModel.occupiedSlots = headerJson.get( 'occupiedSlots', None )
   return headerInfoModel

def SmashClientsAllCmdHandler( mode, args ):
   whoAllModel = SmashModel.WhoAll( _prettyOutput=None )

   fmt = mode.session_.outputFormat()
   jsonFormat = ( fmt == JSON )
   output = showSmashClientsAll( mode, args, json=jsonFormat )
   if jsonFormat:
      # Populate our model with our json output.
      for table, info in JsonUtils.loads( output ).items():
         headerInfo = info[ 'headerInfo' ]
         headerInfoModel = _getHeaderInfoModel( headerInfo )

         tableInfoModel = SmashModel.TableInfo( headerInfo=headerInfoModel,
                                                writer=None, shadow=None,
                                                keyshadow=None, reader=None )

         tableInfoModel.setAttrsFromDict( info[ 'clientInfo' ] )

         whoAllModel.paths[ table ] = tableInfoModel
   else:
      # The user is requesting for text output. Give them the plain output
      # of running /usr/bin/smash --who-all.
      whoAllModel = SmashModel.WhoAll( _prettyOutput=output )

   return whoAllModel
