#
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import SystemdCli
import Tac
import CliDynamicSymbol

SystemdDynamicModels = CliDynamicSymbol.loadDynamicPlugin( "SystemdModels" )

def showSystemdMountsDetail( mode, args=None ):
   def skipRemainingLines( idx, lines ):
      # Skip remaining lines until lowest indentation level
      while idx < len( lines ) and ( not lines[ idx ] or
                                     lines[ idx ][ 0 ].isspace() ):
         idx += 1
      return idx

   def parseMountpointInfo( idx, lines ):
      fsMountInfo = SystemdDynamicModels.SystemdMountpointInfo()
      assert lines[ idx ].startswith( "* " )
      nameDesc = lines[ idx ].split( None, 2 )  # mount name, description
      fsMountInfo.mountDesc = nameDesc[ 1 ]     # mount description
      if len( nameDesc ) == 3:  # If description is included, show it
         fsMountInfo.mountDesc = nameDesc[ 2 ][ 2 : ] # mount description
      idx += 2                                  # Skip "Loaded:" line as well
      idx = SystemdCli.skipDropInLines( idx, lines ) # Skip "Drop-In:" lines
      fsMountInfo.mountState, fsMountInfo.mountTime = SystemdCli.parseActiveLine(
                                                                lines[ idx ] )
      idx += 1
      fsMountInfo.mountPath = lines[ idx ].split( ':', 1 )[ 1 ][ 1 : ]
      idx += 1
      fsMountInfo.fsType = lines[ idx ].split( ':', 1 )[ 1 ][ 1 : ]
      idx += 1
      idx = skipRemainingLines( idx, lines )

      return idx, nameDesc[ 1 ], fsMountInfo

   mountpointsDetail = {}
   cmd = [ '/usr/bin/systemctl', 'status', '*.mount' ]
   output = Tac.run( cmd, asRoot=True, stdout=Tac.CAPTURE,
                     stderr=Tac.DISCARD, ignoreReturnCode=True,
                     env=SystemdCli.systemctlEnv() )
   l = output.splitlines()
   idx = 0
   while idx < len( l ):
      idx, mountName, mountInfo = parseMountpointInfo( idx, l )
      mountpointsDetail[ mountName ] = mountInfo
      idx = SystemdCli.skipBlankWarningLines( idx, l )
      idx = SystemdCli.skipTillNextUnitLine( idx, l )

   model = SystemdDynamicModels.SystemdMountpointsDetail()
   model.systemdMountpointsInfo = mountpointsDetail
   return model

def showSystemdStatusBrief( mode, args ):
   model = SystemdDynamicModels.SystemdStatusBrief()
   if 'services' in args:
      units = [ 'service' ]
   elif 'sockets' in args:
      units = [ 'socket' ]
   elif 'mountpoints' in args:
      units = [ 'mount' ]
   else:
      units = [ 'service', 'socket', 'mount' ]

   ents = {}
   for unit in units:
      cmd = [ '/usr/bin/systemctl', '--full', '--no-legend', '--no-pager',
              f'--type={unit}' ]
      output = Tac.run( cmd, asRoot=True, stdout=Tac.CAPTURE,
                        stderr=Tac.DISCARD,
                        env=SystemdCli.systemctlEnv() )
      for l in output.splitlines():
         parts = l.split( None, 4 )
         assert len( parts ) > 4
         status = SystemdDynamicModels.SystemdUnitStatus()
         status.unitState = parts[ 3 ]
         status.unitDesc = parts[ 4 ]
         ents[ parts[ 0 ] ] = status
   model.unitsStatus = ents
   return model

def showSystemdAllUnitsDetail( mode, args ):
   model = SystemdDynamicModels.SystemdAllUnitsDetail()
   model.systemdServices = SystemdCli.showSystemdServicesDetail( mode )
   model.systemdSockets = SystemdCli.showSystemdSocketsDetail( mode )
   model.systemdMounts = showSystemdMountsDetail( mode )
   return model
