# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from AgentCommandRequest import runCliPrintSocketCommand
import AgentDirectory
from CliDynamicSymbol import CliDynamicPlugin
from CliModel import cliPrinted
import PseudowireAgent

VplsModel = CliDynamicPlugin( 'VplsModel' )

def executeCommand( mode, params, model ):
   if not AgentDirectory.agentIsRunning( mode.entityManager.sysname(),
                                         PseudowireAgent.name ):
      mode.addError( 'Pseudowire agent is inactive' )
      return None
   paramStr = ' '.join( k + '=' + str( v ) for k, v in params.items() )
   return runCliPrintSocketCommand( mode.entityManager,
                                    PseudowireAgent.name,
                                    'vpls',
                                    paramStr,
                                    mode,
                                    keepalive=True,
                                    model=model )

def doShowVpls( mode, params ):
   model = executeCommand( mode, params, VplsModel.Vpls )
   return cliPrinted( model ) if model else None

def showVplsHandler( mode, args ):
   params = {}
   if 'VLAN_ID' in args:
      params[ 'vlan' ] = args[ 'VLAN_ID' ]
   elif 'INSTANCE_NAME' in args:
      params[ 'instance' ] = args[ 'INSTANCE_NAME' ]
      if 'GROUP_NAME' in args:
         params[ 'group' ] = args[ 'GROUP_NAME' ]
   elif 'NEIGHBOR_ADDRESS' in args:
      params[ 'neighbor' ] = args[ 'NEIGHBOR_ADDRESS' ]
      # Pseudowire specified thorugh LdpKey information
      if 'PSEUDOWIRE_ID' in args:
         params[ 'pseudowire' ] = 'ldp'
         params[ 'id' ] = args[ 'PSEUDOWIRE_ID' ]
      else:
         params[ 'pseudowire' ] = 'group'
         params[ 'pwInstance' ] = args[ 'PW_INSTANCE_NAME' ]
         params[ 'pwGroup' ] = args[ 'PW_GROUP_NAME' ]
   elif 'INTERFACE' in args:
      params[ 'pseudowire' ] = 'interface'
      params[ 'interface' ] = args[ 'INTERFACE' ]
   elif 'PSEUDOWIRE_NAME' in args:
      params[ 'pseudowire' ] = 'name'
      params[ 'name' ] = args[ 'PSEUDOWIRE_NAME' ]
   if 'detail' in args:
      params[ 'detail' ] = 'Y'
   return doShowVpls( mode, params )

def showVplsPseudowireBriefHandler( mode, args ):
   params = { 'brief': 'Y' }
   keywords = ( 'vlan', 'group', 'neighbor' )
   for keyword in keywords:
      value = args.get( keyword.upper() )
      if value is not None:
         params[ keyword ] = value
   if 'INSTANCE_NAME' in args:
      params[ 'instance' ] = args[ 'INSTANCE_NAME' ]
   if 'pseudowire-type' in args:
      params[ 'pseudowireType' ] = args[ 'PW_TYPE' ]

   return doShowVpls( mode, params )
