# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliPlugin.XcvrAllStatusDir
from CliPlugin.XcvrConfigCli import ( getXcvrConfigCliDir,
                                      getXcvrConfigCliForConfigCommand,
                                      xcvrConfigCliDelete )
from TypeFuture import TacLazyType
import CliGlobal

gv = CliGlobal.CliGlobal( xcvrStatusDir=None )

XcvrElectricalConfigType = TacLazyType( 'Xcvr::XcvrElectricalConfigType' )
LpoType = TacLazyType( 'Xcvr::LpoType' )

def getXcvrDirAndConfig( mode, create ):
   intf = mode.intf.name
   xcvrConfigCliDir = getXcvrConfigCliDir( intf )
   xcvrConfigCli = getXcvrConfigCliForConfigCommand( intf, xcvrConfigCliDir, create )
   return xcvrConfigCliDir, xcvrConfigCli

# --------------------------------------------------------------------------------
# [ no | default ] transceiver electrical drive < linear | limiting >
# --------------------------------------------------------------------------------

def transceiverElectricalDriveHandler( mode, args ):
   driveType = getattr( XcvrElectricalConfigType, args[ 'DRIVE' ] )
   _, xcvrConfigCli = getXcvrDirAndConfig( mode, True )
   xcvrConfigCli.overrideLpoType = driveType

def transceiverElectricalDriveNoDefHandler( mode, args ):
   xcvrConfigCliDir, xcvrConfigCli = getXcvrDirAndConfig( mode, False )
   if xcvrConfigCli:
      xcvrConfigCli.overrideLpoType = XcvrElectricalConfigType.unset

      if xcvrConfigCliDelete( xcvrConfigCli ):
         del xcvrConfigCliDir.xcvrConfigCli[ mode.intf.name ]

# --------------------------------------------------------------------------------
# [ no | default ] transceiver electrical signal bandwidth < high | low >
# --------------------------------------------------------------------------------

def transceiverElectricalSignalHandler( mode, args ):
   bandwidthConfig = getattr( LpoType, args[ 'BANDWIDTH' ] + 'Bw' )
   _, xcvrConfigCli = getXcvrDirAndConfig( mode, True )
   xcvrConfigCli.signalBwConfig = bandwidthConfig

def transceiverElectricalSignalNoDefHandler( mode, args ):
   xcvrConfigCliDir, xcvrConfigCli = getXcvrDirAndConfig( mode, False )
   if xcvrConfigCli:
      xcvrConfigCli.signalBwConfig = LpoType.none

      if xcvrConfigCliDelete( xcvrConfigCli ):
         del xcvrConfigCliDir.xcvrConfigCli[ mode.intf.name ]

# ------------------------------------------------------
# Plugin method
# ------------------------------------------------------
def Plugin( em ):
   gv.xcvrStatusDir = CliPlugin.XcvrAllStatusDir.xcvrAllStatusDir( em )
