# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
#
# This file contains the CLI command definition for the
# '[no|default] transceiver diag management' command.

import CliCommand
from CliPlugin.XcvrConfigCli import getXcvrConfigCliDirHelper
from CliPlugin.XcvrConfigCli import getXcvrConfigCliForConfigCommand
from CliPlugin.XcvrConfigCli import xcvrConfigCliDelete
import ConfigMount
import CliGlobal

gv = CliGlobal.CliGlobal( xcvrConfigCliSliceDir=None )

# --------------------------------------------------------------------------------
# [ no | default ] transceiver diag management
# --------------------------------------------------------------------------------
def TransceiverDiagManagementCmdHandler( mode, args ):
   noOrDefault = CliCommand.isNoOrDefaultCmd( args )
   intfName = mode.intf.name
   xcvrConfigCliDir = getXcvrConfigCliDirHelper( intfName,
                                                 gv.xcvrConfigCliSliceDir )
   # Pass in 'not noOrDefault' for 'create', meaning we will create a
   # xcvrConfigCli object only when the command is NOT the no/default variant.
   xcvrConfigCli = getXcvrConfigCliForConfigCommand( intfName,
                                                     xcvrConfigCliDir,
                                                     not noOrDefault )
   if xcvrConfigCli is None:
      assert noOrDefault
      return

   assert xcvrConfigCli
   forceManagement = not noOrDefault
   xcvrConfigCli.forceQsfpManagementMode = forceManagement

   if xcvrConfigCliDelete( xcvrConfigCli ):
      del xcvrConfigCliDir.xcvrConfigCli[ intfName ]

# -----------------------------------------------------------------------------------
# Plugin
# -----------------------------------------------------------------------------------

def Plugin( em ):
   gv.xcvrConfigCliSliceDir = ConfigMount.mount( em,
      "hardware/xcvr/cli/config/slice", "Tac::Dir", "wi" )
