# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin.XcvrConfigCli import getXcvrConfigCliDirHelper
from CliPlugin.XcvrConfigCli import getXcvrConfigCliForConfigCommand
from CliPlugin.XcvrConfigCli import xcvrConfigCliDelete

def transceiverDiagSimulateRemovedCmdHelper( intfName, isRemoval,
                                             xcvrConfigCliSliceDir ):
   xcvrConfigCliDir = getXcvrConfigCliDirHelper( intfName, xcvrConfigCliSliceDir )
   # Pass in 'not noOrDefault' for 'create', meaning we will create a
   # xcvrConfigCli object only when the command is NOT the no/default variant.
   xcvrConfigCli = getXcvrConfigCliForConfigCommand( intfName, xcvrConfigCliDir,
                                                     isRemoval )
   if xcvrConfigCli is None:
      assert not isRemoval
      # no xcvrConfigCli to clean on this interface
      return

   assert xcvrConfigCli
   if isRemoval:
      xcvrConfigCli.forceModuleRemoved = True
      xcvrConfigCli.forceModuleRemovedChanged += 1
   else:
      xcvrConfigCli.forceModuleRemoved = False
      xcvrConfigCli.forceModuleRemovedChanged += 1
      if xcvrConfigCliDelete( xcvrConfigCli ):
         del xcvrConfigCliDir.xcvrConfigCli[ intfName ]

def getXcvrConfigCli( intfName, xcvrConfigCliSliceDir ):
   xcvrConfigCliDir = getXcvrConfigCliDirHelper( intfName, xcvrConfigCliSliceDir )
   return xcvrConfigCliDir.xcvrConfigCli.get( intfName )
