# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

######################################################################
#
# Guard codes.
#
# guard functions should return None, or one of these.
#

guardNotThisEosVersion = 'unimplemented in this EOS version'
guardNotThisAbootVersion = 'unimplemented in this Aboot version'
guardNotThisPlatform = 'not supported on this hardware platform'
guardNoLicense = 'additional software license required'
guardNotThisSupervisor = 'not available on this supervisor'
guardNotSsoProtocol = 'only supported for sso protocol'
guardNotSimplexProtocol = 'only supported for simplex protocol'
guardNonDefaultVrf = 'not supported in non-default vrf'
guardNotPermitted = 'not permitted for the current user'
guardNotThisInterface = 'not supported on this interface'
guardNotThisXcvrSlotType = 'not supported on this transceiver slot type'
guardNotThisTcamFeature = 'attribute not supported on this TCAM feature'

allGuards = ( guardNotThisEosVersion, guardNotThisAbootVersion,
              guardNotThisPlatform, guardNoLicense, guardNotThisSupervisor,
              guardNotSsoProtocol, guardNotSimplexProtocol, guardNonDefaultVrf,
              guardNotPermitted, guardNotThisInterface, guardNotThisXcvrSlotType,
              guardNotThisTcamFeature )
#
# end guard codes.
#
######################################################################
