#!/usr/bin/env python3
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class ServerGroupMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'aaa group server %s' % self.param_

   def __init__( self, groupType, groupName ):
      self.modeKey = "sg-%s" % groupType # pylint: disable=consider-using-f-string
      self.longModeKey = f"sg-{groupType}-{groupName}"
      CliMode.ConfigMode.__init__( self, groupType + ' ' + groupName )

class RoleMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'role %s' % self.param_ # pylint: disable=consider-using-f-string

   def __init__( self, role ):
      self.modeKey = "role"
      self.longModeKey = "role-%s" % role # pylint: disable=consider-using-f-string
      CliMode.ConfigMode.__init__( self, role )
