#!/usr/bin/env python3
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

import CliMode

class BaseAclMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      if self.aclType == 'mac':
         cmd = 'mac access-list %s' % self.param_
      elif self.aclType == 'ipv6':
         if self.standard:
            cmd = 'ipv6 access-list standard %s' % self.param_
         else:
            cmd = 'ipv6 access-list %s' % self.param_
      elif self.standard:
         cmd = 'ip access-list standard %s' % self.param_
      else:
         cmd = 'ip access-list %s' % self.param_
      if self.dynamic:
         cmd += ' dynamic'
      return cmd

   def __init__( self, aclType, standard, aclName, dynamic=False ):
      self.aclType = aclType
      self.standard = standard
      self.dynamic = dynamic
      if self.aclType == 'mac':
         self.modeKey = "mac-acl"
         self.longModeKey = "mac-acl-%s" % aclName
      elif self.aclType == 'ipv6':
         if self.standard:
            self.modeKey = "std-ipv6-acl"
            self.longModeKey = "std-ipv6-acl-%s" % aclName
         else:
            self.modeKey = "ipv6-acl"
            self.longModeKey = "ipv6-acl-%s" % aclName
      elif self.standard:
         self.modeKey = "std-acl"
         self.longModeKey = "std-acl-%s" % aclName
      else:
         self.modeKey = "acl"
         self.longModeKey = "acl-%s" % aclName
      if self.dynamic:
         self.modeKey = "dyn-" + self.modeKey
         self.longModeKey = "dyn-" + self.longModeKey
      CliMode.ConfigMode.__init__( self, aclName )

class CpMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'system control-plane'

   def __init__( self, param ):
      self.modeKey = self.longModeKey = "system-cp"
      CliMode.ConfigMode.__init__( self, param )
