# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from BasicCli import ConfigModeBase
from CliMode import ConfigMode

class CpuTrafficPolicyEnforcementModeBase( ConfigMode ):
   '''
   Used by Cli/CliSave plugins.
   '''
   def enterCmd( self ):
      if self.vrfName == 'all':
         return ( f"cpu traffic-policy {self.trafficPolicyName} "
                  f"vrf {self.vrfName}" )
      else:
         return ( f"cpu traffic-policy {self.trafficPolicyName} "
                  "fallback traffic-policy none" )

   def __init__( self, param ):
      self.trafficPolicyName, self.vrfName, parentMode = param
      self.modeKey = "cpu-policy-enforce"
      self.longModeKey = "cpu-%s-enforce" % ( self.trafficPolicyName )
      ConfigMode.__init__( self, param, parentMode=parentMode )

class CpuTrafficPolicyEnforcementConfigMode(
      CpuTrafficPolicyEnforcementModeBase, ConfigModeBase ):
   name = "cpu-policy enforcement config"

   def __init__( self, parent, session, context, **kwargs ):
      self.context = context
      assert self.context
      self.trafficPolicyName = self.context.trafficPolicyName
      self.vrfName = self.context.vrfName
      param = ( self.trafficPolicyName, self.vrfName, parent )
      CpuTrafficPolicyEnforcementModeBase.__init__( self, param )
      ConfigModeBase.__init__( self, parent, session )

   def abort( self ):
      if self.context is not None:
         self.context.abort()
         self.context = None
      self.session_.gotoParentMode()

   def commitContext( self ):
      if self.context is not None:
         self.context.commit()
         self.context = None

   def commit( self ):
      self.commitContext()
      self.session_.gotoParentMode()

   def onExit( self ):
      self.commitContext()
      super().onExit()
