# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
import BasicCli

class BessDpiModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'platform sfe dpi'

   def __init__( self ):
      self.modeKey = "dpi"
      self.longModeKey = "platform-sfe-dpi"
      CliMode.ConfigMode.__init__( self, None, parentMode=CliMode.ConfigMode )

class BessDpiEngineConfigMode( BessDpiModeBase, BasicCli.ConfigModeBase ):
   ''' Configuration mode for bess dpi engine '''
   name = 'platform sfe dpi'

   def __init__( self, parent, session ):
      BessDpiModeBase.__init__( self )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

   def onExit( self ):
      print( "Please save your config and restart the"
            " Sfe agent for your changes to take effect." )
      BasicCli.ConfigModeBase.onExit( self )
