#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

import CliMode
from IpLibConsts import DEFAULT_VRF

class RoutingBfdMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'router bfd'

   def __init__( self, param ):
      self.modeKey = "router"
      self.longModeKey = "router-bfd"
      self.modeEnabled = param
      CliMode.ConfigMode.__init__( self, param )

class RoutingBfdPeerMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'peer %s' % self.peerAddr

   def __init__( self, param ):
      self.peerAddr = param
      self.vrfName = DEFAULT_VRF
      self.modeKey = 'peer'
      self.longModeKey = 'router-bfd-peer-%s' % self.peerAddr
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingBfdMode )

class RoutingBfdVrfMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'vrf %s' % self.vrfName

   def __init__( self, param ):
      self.vrfName = param
      self.modeKey = 'vrf'
      self.longModeKey = 'router-bfd-vrf-%s' % self.vrfName
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingBfdMode )

class RoutingBfdVrfPeerMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'peer %s' % self.peerAddr

   def __init__( self, param ):
      self.vrfName, self.peerAddr = param
      self.modeKey = 'peer'
      self.longModeKey = 'router-bfd-vrf-{}-peer-{}'.format( self.vrfName,
                                                             self.peerAddr )
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingBfdVrfMode )

class RoutingBfdSbfdMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'sbfd'

   def __init__( self, param ):
      self.modeKey = 'sbfd'
      self.longModeKey = 'router-bfd-sbfd'
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingBfdMode )
