#!/usr/bin/env python3
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliMode, re
from CliMode.MaintenanceMode import MaintenanceMode

dynamicComponentRe = "<Dynamic.+><(.+)><.*>"
vrfRe = "<Dynamic.+><.+><vrf-(.+)>"

def setParamVal( param, enterCmd=False ):
   if re.search( dynamicComponentRe, param ):
      bgpPeer = re.search( dynamicComponentRe, param ).group( 1 )
      newParam = bgpPeer
      if re.search( vrfRe, param ):
         vrf = re.search( vrfRe, param ).group( 1 )
         if vrf != 'default':
            if enterCmd:
               param = newParam + ' vrf ' + vrf
            else:
               param = newParam + '-vrf-' + vrf
         else:
            param = newParam
   return param

class BgpMaintenanceMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      peerAndVrf = setParamVal( self.param_, True )
      return 'bgp %s' % peerAndVrf # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      modeParam = setParamVal( param )
      self.modeKey = 'maint-bgp'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'maint-bgp-%s' % modeParam
      CliMode.ConfigMode.__init__( self, param, parentMode=MaintenanceMode )
