# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliMode
from CliMode.MaintenanceMode import MaintenanceMode

class BgpMaintenanceProfileMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'profile bgp %s' % self.param_ # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      self.modeKey = 'profile-bgp'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'profile-bgp-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=MaintenanceMode )
