#!/usr/bin/env python3
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class CfmModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'cfm'

   def __init__( self, param ):
      self.modeKey = 'cfm'
      self.longModeKey = 'cfm'
      CliMode.ConfigMode.__init__( self, param, parentMode=CliMode.ConfigMode )

class MaintenanceDomainModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return '{} {} {} {}'.format( 'domain',
                                   self.domainName, 'level', self.mdLevel )

   def __init__( self, param ):
      ( self.domainName, self.mdLevel ) = param
      self.modeKey = ( "cfm-md-%s" % self.domainName )
      self.longModeKey = ( "cfm-md-%s" % self.domainName )
      CliMode.ConfigMode.__init__( self, param, parentMode=CfmModeBase )

class CfmProfileModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return '{} {}'.format( 'profile', self.cfmProfileName )

   def __init__( self, param ):
      self.cfmProfileName = param
      self.modeKey = ( "cfm-profile-%s" % self.cfmProfileName )
      self.longModeKey = ( "cfm-profile-%s" % self.cfmProfileName )
      CliMode.ConfigMode.__init__( self, param, parentMode=CfmModeBase )

class MaintenanceAssociationModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return '{} {}'.format( 'association', self.maNameId )

   def __init__( self, param ):
      ( self.domainName, self.maNameId ) = param
      self.modeKey = ( f"cfm-md-{self.domainName}-ma-{self.maNameId}" )
      self.longModeKey = ( f"cfm-md-{self.domainName}-ma-{self.maNameId}" )
      CliMode.ConfigMode.__init__( self, param,
                                   parentMode=MaintenanceDomainModeBase )

class LocalMaintenanceEndPointModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return '{} {}'.format( 'end-point', self.localMepId )

   def __init__( self, param ):
      ( self.domainName, self.maNameId, self.localMepId ) = param
      self.modeKey = (
         f"cfm-md-{self.domainName}-ma-{self.maNameId}-mep{self.localMepId}" )
      self.longModeKey = ( "cfm-md-{}-ma-{}-mep{}".format( self.domainName,
                                                       self.maNameId,
                                                       self.localMepId ) )
      CliMode.ConfigMode.__init__( self, param,
                                   parentMode=MaintenanceAssociationModeBase )

class RemoteMaintenanceEndPointModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return '{} {} {}'.format( 'remote', 'end-point', self.remoteMepId )

   def __init__( self, param ):
      ( self.domainName, self.maNameId, self.remoteMepId ) = param
      self.modeKey = (
         f"cfm-md-{self.domainName}-ma-{self.maNameId}-rmep{self.remoteMepId}" )
      self.longModeKey = ( "cfm-md-{}-ma-{}-rmep{}".format( self.domainName,
                                                        self.maNameId,
                                                        self.remoteMepId ) )
      CliMode.ConfigMode.__init__( self, param,
                                   parentMode=MaintenanceAssociationModeBase )
