#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class ClbMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'load-balance cluster'

   def __init__( self, param ):
      self.modeKey = "clb"
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, param )

class ClbFlowLearningMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'flow source learning'

   def __init__( self, param ):
      self.modeKey = "clb-flow-learning"
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, param )

class ClbPortGroupMode( CliMode.ConfigMode ):

   def groupTypeStr( self ):
      return "host" if self.groupType == "intfGroupTypeHost" else "uplink"

   def enterCmd( self ):
      return f'port group {self.groupTypeStr()} {self.groupName}'

   def __init__( self, groupType, groupName ):
      self.groupType = groupType
      self.groupName = groupName
      groupTypeStr = self.groupTypeStr()
      self.modeKey = f"clb-{groupTypeStr}"
      self.longModeKey = f"clb-{groupTypeStr}-{groupName}"
      CliMode.ConfigMode.__init__( self, groupName )

class ClbMatchPolicyMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return f'flow match policy {self.policyName}'

   def __init__( self, policyName ):
      self.policyName = policyName
      self.modeKey = "clb-match"
      self.longModeKey = f"clb-match-{policyName}"
      CliMode.ConfigMode.__init__( self, policyName )
