# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class CtMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'service container tracer'

   def __init__( self ):
      self.modeKey = 'cvx-container-tracer'
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, None, parentMode=CliMode.ConfigMode )


class CtClusterMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'cluster %s' % self.param_

   def __init__( self, param ):
      self.modeKey = 'cvx-container-tracer-cluster-%s' % param
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, param )

