#!/usr/bin/env python3
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliMode

clusterDefaultName = Tac.Value( "Controller::Constants" ).clusterDefaultName

class CvxConfigMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return ( 'cvx %s' % self.param_ if self.modeName( self.param_ ) !=
               clusterDefaultName else 'cvx' )

   def __init__( self, param ):
      # pylint: disable-next=consider-using-f-string
      self.modeKey = ( 'cvx-%s' % param if self.modeName( param ) !=
                       clusterDefaultName else 'cvx' )
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, param )

   @staticmethod
   def modeName( clusterName ):
      return clusterName or clusterDefaultName
