# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
from CliMode import ConfigMode
import Tac

# TODO: cleanup on no deamon (need to enhance DaemonCli to allow cleanup registry)
# BUG811799
sdkHandles = {}


class DaemonCliMode( ConfigMode, BasicCli.ConfigModeBase ):
   name = 'Daemon cli configuration'

   def enterCmd( self ):
      return 'cli'

   def __init__( self, parent, session, daemonName, genCfg=None, cfg=None ):
      self.daemonName = daemonName
      self.genericAgentCfg = genCfg
      self.aclConfig = cfg
      # pylint: disable-next=consider-using-f-string
      self.modeKey = "daemon-%s-cli" % daemonName
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = "daemon-%s-cli" % daemonName
      ConfigMode.__init__( self, parent )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

      if daemonName not in sdkHandles:
         # this is for debugs, so be lazy
         import eossdk  # pylint: disable=import-outside-toplevel
         self.sdk = eossdk.Sdk( daemonName,
                                Tac.addressOf( self.entityManager.cEntityManager() ))
         sdkHandles[daemonName] = self.sdk
      else:
         self.sdk = sdkHandles[daemonName]
      self.ipRouteMgr = self.sdk.get_ip_route_mgr()
      self.sdk.initialize_context()
