# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.Classification import FieldSetBasePrefixConfigMode
import BasicCli

class DirectedBroadcastModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "ip directed-broadcast"

   def __init__( self ):
      self.modeKey = "ip-directed-broadcast"
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, None,
                                   parentMode=CliMode.ConfigMode )

class DirectedBroadcastConfigMode( DirectedBroadcastModeBase,
                                   BasicCli.ConfigModeBase ):
   """ Configuration Mode for ip Directed-Broadcast """
   name = "ip-directed-broadcast"

   def __init__( self, parent, session ):
      DirectedBroadcastModeBase.__init__( self )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

   def abort( self ):
      pass

   def commit( self ):
      pass

class FieldSetIpPrefixConfigMode( FieldSetBasePrefixConfigMode ):
   name = "directed-broadcast field-set ipv4 prefix configuration"
