# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class DynPfxSessionBgpMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'dynamic prefix-list %s session bgp' % self.sessionBgpDplList

   def __init__( self, param ):
      self.modeKey = 'dyn-pfx-bgp-session'
      self.sessionBgpDplList = param
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'dyn-pfx-bgp-session-%s' % param
      CliMode.ConfigMode.__init__( self, param )

class DynamicPrefixListMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'dynamic prefix-list %s' % self.dynPfxList

   def __init__( self, param ):
      self.modeKey = 'dyn-pfx'
      self.dynPfxList = param
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'dyn-pfx-%s' % param
      CliMode.ConfigMode.__init__( self, param )
