#!/usr/bin/env python3
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class EoamConfigModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'monitor ethernet oam'

   def __init__( self ):
      self.modeKey = 'eoam'
      self.longModeKey = 'eoam'
      CliMode.ConfigMode.__init__( self, self.longModeKey )

class EoamProfileModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'profile %s' % self.profileName

   def __init__( self, param ):
      self.profileName  = param
      self.modeKey = 'eoam-profile'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'eoam-profile-%s' % self.profileName
      CliMode.ConfigMode.__init__( self, self.longModeKey,
                                   parentMode=EoamConfigModeBase )

class LinkMonitoringModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'link-error'

   def __init__( self, param ):
      self.modeKey = 'eoam-profile-link-error'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'eoam-profile-%s-link-error' % param
      CliMode.ConfigMode.__init__( self, self.longModeKey,
                                   parentMode=EoamProfileModeBase )
