#!/usr/bin/env python3
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliMode
import BasicCli

class FabricModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "interface fabric"

   def __init__( self, param ):
      self.modeKey = "fabric"
      self.longModeKey = "if-fabric"
      CliMode.ConfigMode.__init__( self, self.longModeKey )

class FabricMode( FabricModeBase, BasicCli.ConfigModeBase ):
   name = "Fabric configuration"

   def __init__( self, parent, session, name=None ):
      FabricModeBase.__init__( self, name )
      BasicCli.ConfigModeBase.__init__( self, parent, session )
