#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.FlowTracker import TrackerModeBase
from FlowTrackerCliUtil import getFtrPromptFromFtrTypeStr

class ExporterModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'exporter %s' % self.expName

   def __init__( self, param ):
      ( self.ftrTypeStr, self.trName, self.expName ) = param
      self.modeKey = 'ftr-tr-exp'
      ftrPrompt = getFtrPromptFromFtrTypeStr( self.ftrTypeStr )
      self.longModeKey = 'ftr-{}-tr-{}-exp-{}'.format(
                                   ftrPrompt, self.trName, self.expName )
      CliMode.ConfigMode.__init__( self, self.longModeKey,
                                   parentMode=TrackerModeBase )

   def instanceRuleKey( self ):
      return self.longModeKey
