# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from FlowTrackerCliUtil import getFtrPromptFromFtrTypeStr

class FlowTrackingModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'flow tracking %s' % self.ftrTypeStr

   def __init__( self, param ):
      self.ftrTypeStr = param
      self.modeKey = "flow-tracking"
      ftrPrompt = getFtrPromptFromFtrTypeStr( self.ftrTypeStr )
      self.longModeKey = "flow-tracking-%s" % ftrPrompt
      CliMode.ConfigMode.__init__( self, param )

   def instanceRuleKey( self ):
      return self.longModeKey
